<?php
/**
 * @var $module
 * @var $settings
 * @var $id
 */

$settings = apply_filters('labb_gallery_carousel_' . $id . '_settings', $settings);

$module::$gallery_counter++;

$settings->gallery_id = $id;

$module::$gallery_counter++;

$settings->gallery_class = !empty($settings->gallery_class) ? sanitize_title($settings->gallery_class) : 'gallery-carousel-' . $module::$gallery_counter;

$items = $settings->gallery_items;

if ($settings->bulk_upload == 'yes') {

    $items = array();

    $ids = $settings->gallery_images;

    if (empty($ids))
        return;

    foreach ($ids as $id):

        $item = array('item_type' => 'image', 'item_image' => $id, 'item_name' => '', 'tags' => '', 'item_link' => '', 'item_description' => '');

        $items[] = (object)$item;

    endforeach;
}

$carousel_settings = [
    'enable_lightbox' => ('yes' === $settings->enable_lightbox),
    'arrows' => ('yes' === $settings->arrows),
    'dots' => ('yes' === $settings->dots),
    'autoplay' => ('yes' === $settings->autoplay),
    'autoplay_speed' => absint($settings->autoplay_speed),
    'animation_speed' => absint($settings->animation_speed),
    'pause_on_hover' => ('yes' === $settings->pause_on_hover),
];

$responsive_settings = [
    'display_columns' => $settings->display_columns,
    'scroll_columns' => $settings->scroll_columns,
    'gutter' => $settings->gutter,
    'tablet_width' => $settings->tablet_width,
    'tablet_display_columns' => $settings->tablet_display_columns,
    'tablet_scroll_columns' => $settings->tablet_scroll_columns,
    'tablet_gutter' => $settings->tablet_gutter,
    'mobile_width' => $settings->mobile_width,
    'mobile_display_columns' => $settings->mobile_display_columns,
    'mobile_scroll_columns' => $settings->mobile_scroll_columns,
    'mobile_gutter' => $settings->mobile_gutter,

];

$carousel_settings = (object)array_merge($carousel_settings, $responsive_settings);

if (!empty($items)) :

    $output = '<div id="labb-gallery-carousel-' . uniqid()
        . '" class="labb-gallery-carousel labb-container ' . $settings->gallery_class
        . '" data-settings=\'' . wp_json_encode($carousel_settings) . '\'>';

    foreach ($items as $item):

        if (!is_object($item))
            continue;

        // No need to populate anything if no image is provided for video or for the image
        if (empty($item->item_image))
            continue;

        $style = '';
        if (!empty($item->tags)) {

            $terms = explode(',', $item->tags);

            foreach ($terms as $term) {
                $style .= ' term-' . $term;
            }
        }

        $item_type = $item->item_type;

        $item_class = ' labb-' . $item_type . '-type';

        $entry_output = '<div class="labb-gallery-carousel-item ' . $style . $item_class . '">';

        $entry_image = '<div class="labb-project-image">';

        $size = isset($settings->image_size) ? $settings->image_size : 'large';

        $src = wp_get_attachment_image_src($item->item_image, $size);

        $photo_data = FLBuilderPhoto::get_attachment_data($item->item_image);

        // Display caption of the photo as item name if no name is specified by the user - useful in bulk upload case
        if (empty($item->item_name))
            $item->item_name = $photo_data->caption;

        // Display description of the photo as item description if no description is specified by the user - useful in bulk upload case
        if (empty($item->item_description))
            $item->item_description = $photo_data->description;

        // set params
        $photo_settings = array(
            'align' => 'center',
            'link_type' => '',
            'crop' => $settings->crop,
            'photo' => $photo_data,
            'photo_src' => $src[0],
            'photo_source' => 'library',
        );

        if ($item_type == 'image' && !empty($item->item_link)) {

            $photo_settings['link_type'] = 'url';

            $photo_settings['link_url'] = $item->item_link;

            $photo_settings['link_target'] = $settings->link_target;
        }

        // render image
        $image_html = labb_get_image_html($photo_settings);;

        $entry_image .= apply_filters('labb_gallery_carousel_thumbnail_html', $image_html, $item, $settings);

        $image_info = '<div class="labb-image-info">';

        $entry_info = '<div class="labb-entry-info">';

        if ($settings->display_item_title == 'yes'):

            $entry_title = '<' . $settings->title_tag . ' class="labb-entry-title">';

            if ($item_type == 'image' && !empty($item->item_link)):

                $entry_title .= '<a href="' . esc_url($item->item_link)
                    . '" title="' . esc_html($item->item_name)
                    . '" target="_blank">'
                    . esc_html($item->item_name)
                    . '</a>';

            else:

                $entry_title .= esc_html($item->item_name);

            endif;

            $entry_title .= '</' . $settings->title_tag . '>';

            $entry_info .= apply_filters('labb_gallery_carousel_entry_info_title', $entry_title, $item, $settings);

        endif;

        if ($item_type == 'youtube' || $item_type == 'vimeo') :

            $video_url = $item->video_link;

            if (!empty($video_url)) :

                $video_lightbox = '<a class="labb-video-lightbox" data-fancybox="' . $settings->gallery_class
                    . '" href="' . $video_url
                    . '" title="' . esc_html($item->item_name)
                    . '" data-description="' . wp_kses_post($item->item_description) . '">';

                $video_lightbox .= '<i class="labb-icon-video-play"></i>';

                $video_lightbox .= '</a>';

                $entry_info .= apply_filters('labb_gallery_carousel_video_lightbox_link', $video_lightbox, $video_url, $item, $settings);

            endif;

        elseif ($item_type == 'html5video' && !empty($item->mp4_video)) :

            $video_id = 'labb-video-' . $item->mp4_video;

            $video_lightbox = '<a class="labb-video-lightbox" data-fancybox="' . $settings->gallery_class
                . '" href="#' . $video_id
                . '" title="' . esc_html($item->item_name)
                . '" data-description="' . wp_kses_post($item->item_description) . '">';

            $video_lightbox .= '<i class="labb-icon-video-play"></i>';

            $video_lightbox .= '</a>';

            $video_lightbox .= '<div id="' . $video_id . '" class="labb-fancybox-video">';

            $mp4_video_data = FLBuilderPhoto::get_attachment_data($item->mp4_video);

            $webm_video_data = FLBuilderPhoto::get_attachment_data($item->webm_video);

            $video_lightbox .= '<video poster="' . $photo_data->url
                . ' width="' . $mp4_video_data->width
                . '" height="' . $mp4_video_data->height
                . '" src="' . $mp4_video_data->url
                . '" autoplay="1" preload="metadata" controls controlsList="nodownload">';

            $video_lightbox .= '<source type="video/mp4" src="' . $mp4_video_data->url . '">';

            $video_lightbox .= '<source type="video/webm" src="' . $webm_video_data->url . '">';

            $video_lightbox .= '</video>';

            $video_lightbox .= '</div>';

            $entry_info .= apply_filters('labb_gallery_carousel_html5video_lightbox_link', $video_lightbox, $item, $settings);

        endif;

        if ($settings->display_item_tags == 'yes'):

            $entry_info .= apply_filters('labb_gallery_carousel_info_tags', '<span class="labb-terms">' . esc_html($item->tags) . '</span>', $item, $settings);

        endif;

        $entry_info .= '</div>';

        $image_info .= apply_filters('labb_gallery_carousel_entry_info', $entry_info, $item, $settings);

        if ($item_type == 'image' && $carousel_settings->enable_lightbox) :

            $image_data = wp_get_attachment_image_src($item->item_image, 'full');

            if ($image_data) :

                $image_src = $image_data[0];

                $anchor_type = (empty($image_src) ? 'labb-click-anywhere' : 'labb-click-icon');

                $lightbox_item = '<a class="labb-lightbox-item ' . $anchor_type
                    . '" data-fancybox="' . $settings->gallery_class
                    . '" href="' . $image_src
                    . '" title="' . esc_html($item->item_name)
                    . '" data-description="' . wp_kses_post($item->item_description) . '">';

                $lightbox_item .= '<i class="labb-icon-full-screen"></i>';

                $lightbox_item .= '</a>';

                $image_info .= apply_filters('labb_gallery_carousel_fancybox_lightbox_link', $lightbox_item, $item, $settings);

            endif;

        endif;

        $image_info .= '</div><!-- .labb-image-info -->';

        $entry_image .= apply_filters('labb_gallery_carousel_image_info', $image_info, $item, $settings);

        $entry_image .= '</div><!-- .labb-project-image -->';

        $entry_output .= apply_filters('labb_gallery_carousel_entry_image', $entry_image, $item, $settings);

        /* Allow users to output whatever data they want to after displaying the image - at present
        we don't display anything but things can change */

        $entry_text = '';

        $entry_output .= apply_filters('labb_gallery_carousel_entry_text', $entry_text, $item, $settings);

        $entry_output .= '</div><!-- .labb-gallery-carousel-item -->';

        $output .= apply_filters('labb_gallery_carousel_item_output', $entry_output, $item, $settings);

    endforeach;

    $output .= '</div><!-- .labb-gallery-carousel -->';

    echo apply_filters('labb_gallery_carousel_output', $output, $settings);

endif;